#include <climits>
#include <algorithm>

#define MAX_M 300000

struct Pick
{
    int pos;
    int count;
};

int pickCount = 0;
Pick picks[MAX_M];

void AddPick(int pos)
{
    int i = 0;
    for (; i < pickCount; ++i)
        if (picks[i].pos == pos)
            break;

    if (i == pickCount)
    {
        ++pickCount;
        picks[i].pos = pos;
        picks[i].count = 1;
        return;
    }

    ++picks[i].count;

    if (i == 0)
        return;

    int j = (i - 1) >> 1; 
    if (picks[j].count < picks[i].count)    
        std::swap(picks[j], picks[i]);
    else if ((i & 1) == 0 && picks[i - 1].count < picks[i].count)
        std::swap(picks[i - 1], picks[i]);
 }

int Slamke(int N, int* A, int M, int* T, int* X, int* Y)
{
    ++A;
    ++T;
    ++X;
    ++Y;

    int count = 0;

    int min = INT_MAX;
    int minPos = -1;
    for (int i = 0; i < N; ++i)
        if (A[i] < min)
        {
            min = A[i];
            minPos = i;
        }
    
    int task = 0;
    while (T[task] == 2 && task != M)
    {
        count += (X[task] == minPos);
        ++task;
    }

    while (task != M)
    {
        int minRangeBegin = X[task], minRangeEnd = Y[task];
        ++task;
        while (T[task] == 1 && task != M)
        {
            if (Y[task] >= minRangeBegin && X[task] < minRangeBegin)
                minRangeBegin = X[task];
            if (X[task] <= minRangeEnd && Y[task] > minRangeEnd)
                minRangeEnd = Y[task];
            ++task;
        }

        pickCount = 0;
        while (T[task] == 2 && task != M)
        {
            if (X[task] >= minRangeBegin && X[task] <= minRangeEnd)
                AddPick(X[task]);
            ++task;
        }

        if (pickCount != 0)
        {
            count += picks[0].count;
            minPos = picks[0].pos;
        }
    }

    return count;
}

/*
10
9 8 7 6 0 1 2 3 4 5
5
1 2 5
1 4 7
2 3 0
2 6 0
2 3 0
*/